#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <limits>
#include <iomanip>

using namespace std;

struct Tacka {
    long long x, y;
    bool operator<(const Tacka& t) const {
        return x < t.x || (x == t.x && y < t.y);
    }
};

long long vektorskiProizvod(const Tacka& O, const Tacka& A, const Tacka& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

double povrsinaPoligona(const vector<Tacka>& omotac) {
    long long povrsina = 0;
    int brojTemena = omotac.size();
    for (int i = 0; i < brojTemena; ++i) {
        povrsina += (omotac[i].x * omotac[(i + 1) % brojTemena].y) - (omotac[i].y * omotac[(i + 1) % brojTemena].x);
    }
    return abs(povrsina) / 2.0;
}

vector<Tacka> konveksniOmotac(vector<Tacka>& tacke) {
    sort(tacke.begin(), tacke.end());
    vector<Tacka> omotac;
    for (int i = 0; i < tacke.size(); ++i) {
        while (omotac.size() >= 2 && vektorskiProizvod(omotac[omotac.size() - 2], omotac.back(), tacke[i]) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }
    int velicinaDonjeg = omotac.size();
    for (int i = tacke.size() - 2; i >= 0; --i) {
        while (omotac.size() > velicinaDonjeg && vektorskiProizvod(omotac[omotac.size() - 2], omotac.back(), tacke[i]) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }
    omotac.pop_back();
    return omotac;
}

double skoroKonveksniOmotacPovrsina(vector<Tacka> tacke) {
    int brojTacaka = tacke.size();
    double minimalnaPovrsina = numeric_limits<double>::max();
    for (int i = 0; i < brojTacaka; ++i) {
        vector<Tacka> smanjeneTacke = tacke;
        smanjeneTacke.erase(smanjeneTacke.begin() + i);
        vector<Tacka> trenutniOmotac = konveksniOmotac(smanjeneTacke);
        double trenutnaPovrsina = povrsinaPoligona(trenutniOmotac);
        if (trenutnaPovrsina < minimalnaPovrsina) {
            minimalnaPovrsina = trenutnaPovrsina;
        }
    }
    return minimalnaPovrsina;
}

int main() {
    int N;
    cin >> N;
    vector<Tacka> tacke(N);
    for (int i = 0; i < N; ++i) {
        cin >> tacke[i].x >> tacke[i].y;
    }
    double minimalnaPovrsina = skoroKonveksniOmotacPovrsina(tacke);
    cout << minimalnaPovrsina << endl;
    return 0;
}